import { datatype, internet } from 'faker';
import { createMountWrapperFactory } from 'tachyon-test-utils';
import { useUpdateVideoPlaybackPosition } from '../../../../hooks';
import { VodPlayingUIBase } from '.';

jest.mock('../../../player', () => ({
  HideablePlayPauseButton: () => <div />,
  MediaSession: () => null,
  PlaybackScrubBar: () => <div />,
  PlayerControls: () => <div />,
  VodPlayerWrapper: () => <div />,
}));

jest.mock('../../../../hooks', () => ({
  useUpdateVideoPlaybackPosition: jest.fn(),
}));
const mockUseUpdateVideoPlaybackPosition =
  useUpdateVideoPlaybackPosition as jest.Mock;

jest.mock('./VodBottomControls', () => ({
  VodBottomControls: () => <div />,
}));

jest.mock('./MutedSegmentPopup', () => ({
  MutedSegmentPopup: () => <div />,
}));

describe(VodPlayingUIBase, () => {
  const setup = createMountWrapperFactory(VodPlayingUIBase, () => ({
    currentUser: null,
    focusIndex: 0,
    onPlaybackEnd: jest.fn(),
    onPlaybackError: jest.fn(),
    video: {
      ' $fragmentRefs': {
        MutedSegmentPopup_muteInfo: true,
        VodBottomControls_video: true,
        VodPlayerBase_video: true,
      },
      ' $refType': 'VodPlayingUI_video',
      id: datatype.uuid(),
      muteInfo: {
        mutedSegmentConnection: null,
      },
      owner: {
        displayName: 'therealderekt',
        login: 'therealderekt',
        roles: null,
      },
      seekPreviewsURL: '',
    },
    vodToken: {
      ' $fragmentRefs': { VodPlayerWrapper_token: true },
    },
  }));

  it('calls the hook to set up video playback position update mutations', () => {
    const { props } = setup({
      currentUser: {
        id: internet.userName(),
      },
    });
    expect(mockUseUpdateVideoPlaybackPosition).toHaveBeenCalledWith({
      userID: props.currentUser!.id,
      videoID: props.video.id,
      videoType: 'VOD',
    });
  });
});
