import { datatype, lorem } from 'faker';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { Redirect, RouteName } from '../../../routing';
import { NotFoundError } from '../../errors';
import { Vod } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlayerController: jest.fn(() => null),
}));

jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));

const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

describe(Vod, () => {
  mockUseStaticEnvironment.mockReturnValue({
    common: { platform: Platform.StarshotDev },
  });
  const setup = createShallowWrapperFactory(Vod, () => ({
    ' $fragmentRefs': { VodPlayerWrapper_token: true },
    currentUser: null,
    queryVariables: {
      platform: Platform.StarshotDev,
      playerType: 'pulsar',
      skipPlayToken: true,
      videoId: datatype.uuid(),
    },
    video: {
      ' $fragmentRefs': {
        VodBottomControls_video: true,
        VodPagePlayer_video: true,
        VodPlayingUI_video: true,
      },
      broadcastType: 'ARCHIVE',
      game: {
        name: lorem.words(5),
      },
      id: datatype.uuid(),
      muteInfo: {
        mutedSegmentConnection: null,
      },
      owner: {
        broadcastSettings: {
          isMature: false,
        },
        displayName: lorem.word(),
        id: datatype.uuid(),
        login: 'therealderekt',
        stream: null,
        subscriptionProducts: [],
      },
      resourceRestriction: null,
      self: {
        isRestricted: false,
      },
      viewCount: 0,
    },
  }));

  it('redirects to the interstitial when the platform is switch', () => {
    mockUseStaticEnvironment.mockReturnValueOnce({
      common: { platform: Platform.Switch },
    });
    const { wrapper } = setup({
      video: {
        id: 'foo',
      },
    });

    expect(wrapper.find(Redirect)).toHaveProp({
      params: {
        route: RouteName.VodInterstitial,
        routeParams: { id: 'foo' },
      },
      replace: true,
    });
  });

  it('renders the not found UX when Vod is not found', () => {
    const { wrapper } = setup({ video: null });
    expect(wrapper.find(NotFoundError)).toExist();
  });
});
