import { useIntl } from 'tachyon-intl';
import { GlowConcernedMonitor } from 'tachyon-more-ui';
import { defaultPageviewTracking, getCurrentUser } from 'tachyon-page-utils';
import { Title } from 'twitch-core-ui';
import { StarshotMain } from '../../common';
import { FullscreenOverlayPrompt } from '../../player';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const WrongFormat: StarshotPage = () => {
  const { formatMessage } = useIntl();

  return (
    <StarshotMain>
      <FullscreenOverlayPrompt>
        <FullscreenOverlayPrompt.Image>
          <GlowConcernedMonitor />
        </FullscreenOverlayPrompt.Image>
        <FullscreenOverlayPrompt.CTA>
          <Title>
            {formatMessage(
              'This channel is not playable on this device at this time.',
              'WrongFormatPage',
            )}
          </Title>
        </FullscreenOverlayPrompt.CTA>
      </FullscreenOverlayPrompt>
    </StarshotMain>
  );
};

WrongFormat.currentUser = getCurrentUser;
WrongFormat.displayName = 'WrongFormatPage';
WrongFormat.navigationBehavior = () => ({
  displayBackButton: true,
  noFocusableContent: true,
});
WrongFormat.pageviewTracking = defaultPageviewTracking;
