import type { TwitchPayloadError } from 'tachyon-relay';
import { errorsArrayIsFatal } from '.';

jest.mock('../../../../config', () => ({
  ALLOWED_PARTIAL_RESPONSE_QUERIES: ['Test_Query'],
}));

describe('configure()', () => {
  const testError: TwitchPayloadError = {
    message: 'test error',
    path: ['/test'],
  };

  describe(errorsArrayIsFatal, () => {
    it('returns false for query matching an allowed entry', () => {
      expect(errorsArrayIsFatal([testError], 'Test_Query')).toEqual(false);
    });

    it('returns true for query similar tp an allowed entry but with different name', () => {
      expect(errorsArrayIsFatal([testError], 'OtherTest_Query')).toEqual(true);
    });

    it('returns true for query not similar to an allowed entry but with different type', () => {
      expect(errorsArrayIsFatal([testError], 'Test_RefetchQuery')).toEqual(
        true,
      );
    });
  });
});
