import type { FC } from 'react';
import { ChatAllowedRoot } from '../../../../framework';

type StarshotChatAllowedRootProps = {
  defaultChatAllowed?: boolean;
};

// istanbul ignore next: trivial
export const StarshotChatAllowedRoot: FC<StarshotChatAllowedRootProps> = ({
  children,
  defaultChatAllowed,
}) => {
  return (
    <ChatAllowedRoot
      children={children}
      defaultChatAllowed={defaultChatAllowed}
    />
  );
};

StarshotChatAllowedRoot.displayName = 'StarshotChatAllowedRoot';
