import type { FC } from 'react';
import type { CurrentUserRootProps } from 'tachyon-auth';
import { CurrentUserRoot } from 'tachyon-auth';
import { useNativeAppProxy } from '../../../../framework';

type StarshotCurrentUserRootProps = Pick<
  CurrentUserRootProps,
  'isLoggedInServerside'
>;

// istanbul ignore next: trivial
export const StarshotCurrentUserRoot: FC<StarshotCurrentUserRootProps> = ({
  children,
  isLoggedInServerside,
}) => {
  const nativeProxy = useNativeAppProxy();

  return (
    <CurrentUserRoot
      children={children}
      isLoggedInServerside={isLoggedInServerside}
      onLogin={nativeProxy.loggedIn}
      onLogout={nativeProxy.loggedOut}
    />
  );
};

StarshotCurrentUserRoot.displayName = 'StarshotCurrentUserRoot';
