import type { FC } from 'react';
import type { TachyonDebugEvent } from 'tachyon-debug-reporter';
import { configTachyonDebug } from 'tachyon-debug-reporter';
import { useCustomTracking } from 'tachyon-event-tracker';
import { isBrowser, useEffectOnce } from 'tachyon-utils';

// istanbul ignore next: trivial
export const StarshotDebugRoot: FC = () => {
  const trackEvent = useCustomTracking<TachyonDebugEvent>();

  useEffectOnce(() => {
    if (isBrowser()) {
      configTachyonDebug(trackEvent);
    }
  });

  return null;
};

StarshotDebugRoot.displayName = 'StarshotDebugRoot';
