import type { FC } from 'react';
import type { SpadeDiscoveryEvent } from 'tachyon-discovery';
import { DiscoveryTrackingRoot, PageviewMedium } from 'tachyon-discovery';
import { useCustomTracking } from 'tachyon-event-tracker';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { flattenHeaderOrParam } from 'tachyon-utils';
import { ITEM_TRACKING_ID, MODEL_TRACKING_ID } from '../../../../../config';
import { RouteName, routeNameFromPathname } from '../../../../../routing';

const SEARCH_CORRELATION_ROUTES = [RouteName.Search, RouteName.Channel];

/**
 * A map of which mediums should be attributed to what routes.
 */
const ROUTE_TO_MEDIUM_MAP: Partial<Record<string, PageviewMedium>> = {
  [RouteName.GamesDirectory]: PageviewMedium.Browse,
  [RouteName.Homepage]: PageviewMedium.Discover,
  [RouteName.Search]: PageviewMedium.Search,
};

// istanbul ignore next: trivial
function getMediumFromRoute(routeName: string): PageviewMedium | undefined {
  return ROUTE_TO_MEDIUM_MAP[routeName];
}

// istanbul ignore next: trivial
export const StarshotDiscoveryTrackingRoot: FC = ({ children }) => {
  const trackEvent = useCustomTracking<SpadeDiscoveryEvent>();
  const { currentPathname, currentQuery } = useRouterUtils();

  return (
    <DiscoveryTrackingRoot
      children={children}
      currentRouteName={routeNameFromPathname(currentPathname)}
      getMediumFromRoute={getMediumFromRoute}
      initialItemTrackingId={flattenHeaderOrParam(
        currentQuery[ITEM_TRACKING_ID],
      )}
      initialModelTrackingId={flattenHeaderOrParam(
        currentQuery[MODEL_TRACKING_ID],
      )}
      onEvent={trackEvent}
      searchCorrelationRoutes={SEARCH_CORRELATION_ROUTES}
    />
  );
};

StarshotDiscoveryTrackingRoot.displayName = 'StarshotDiscoveryTrackingRoot';
