import type { FC } from 'react';
import type { EnvironmentRootProps } from 'tachyon-environment';
import {
  EnvironmentRoot,
  LAUNCHER_VERSION_QUERY_PARAM_KEY,
} from 'tachyon-environment';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { flattenHeaderOrParam } from 'tachyon-utils';
import { CLIENT_APP } from '../../../../../config';

export type StarshotEnvironmentRootProps = Pick<
  EnvironmentRootProps['common'],
  'appEnvironment' | 'language' | 'platform'
>;

// istanbul ignore next: trivial
export const StarshotEnvironmentRoot: FC<StarshotEnvironmentRootProps> = ({
  appEnvironment,
  children,
  language,
  platform,
}) => {
  const { currentQuery } = useRouterUtils();

  return (
    <EnvironmentRoot
      children={children}
      client={{
        launcherVersion: flattenHeaderOrParam(
          currentQuery[LAUNCHER_VERSION_QUERY_PARAM_KEY],
        ),
      }}
      common={{
        appEnvironment,
        appVersion: process.env.BUILD_ID,
        clientApp: CLIENT_APP,
        language,
        platform,
      }}
      networkStatusDebounceWait={null}
    />
  );
};

StarshotEnvironmentRoot.displayName = 'StarshotEnvironmentRoot';
