import type { FC } from 'react';
import { useMemo } from 'react';
import { useDynamicSettings } from 'tachyon-dynamic-settings';
import type { EventReporterRootProps } from 'tachyon-event-reporter';
import { EventReporterRoot } from 'tachyon-event-reporter';
import type { StarshotDynamicSettings } from '../../../../../config';
import { SPADE_BATCH_WINDOW_MS } from '../../../../../config';

// istanbul ignore next: trivial
export const StarshotEventReporterRoot: FC = ({ children }) => {
  const { spadeUrl } = useDynamicSettings<StarshotDynamicSettings>();

  const spadeOpts: EventReporterRootProps['spade'] = useMemo(
    () => ({ batchWindowMs: SPADE_BATCH_WINDOW_MS, spadeUrl }),
    [spadeUrl],
  );

  return <EventReporterRoot children={children} spade={spadeOpts} />;
};

StarshotEventReporterRoot.displayName = 'StarshotEventReporterRoot';
