import type { FC } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { useReportEvent } from 'tachyon-event-reporter';
import type { EventTrackerRootProps } from 'tachyon-event-tracker';
import { EventTrackerRoot } from 'tachyon-event-tracker';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import { flattenHeaderOrParam } from 'tachyon-utils';
import { routeNameFromPathname } from '../../../../../routing';

type StarshotEventTrackerRootProps = Pick<
  EventTrackerRootProps,
  'getUserTracking'
> & {
  inError: boolean;
};

// istanbul ignore next: trivial
export const StarshotEventTrackerRoot: FC<StarshotEventTrackerRootProps> = ({
  children,
  getUserTracking,
  inError,
}) => {
  const reportEvent = useReportEvent();
  const {
    currentPathname,
    currentQuery: { tt_content, tt_email_id, tt_medium },
  } = useRouterUtils();

  const currentRouteName = routeNameFromPathname(currentPathname);
  const { client, common } = useStaticEnvironment();

  return (
    <EventTrackerRoot
      children={children}
      getUserTracking={getUserTracking}
      interactionMedium={currentRouteName}
      location={inError ? 'internal_error' : currentRouteName}
      onEvent={reportEvent}
      staticProperties={{
        appVersion: common.appVersion,
        clientApp: common.clientApp,
        deviceID: client.deviceID,
        language: common.language,
        netInfo: client.netInfo,
        platform: common.platform,
        sessionID: client.sessionID,
      }}
      twitchTracking={{
        content: flattenHeaderOrParam(tt_content),
        emailID: flattenHeaderOrParam(tt_email_id),
        medium: flattenHeaderOrParam(tt_medium),
      }}
    />
  );
};

StarshotEventTrackerRoot.displayName = 'StarshotEventTrackerRoot';
