import type { FC } from 'react';
import { useRef } from 'react';
import { useCustomTracking } from 'tachyon-event-tracker';
import type {
  ExperimentBranchEvent,
  ExperimentsRootProps,
} from 'tachyon-experiments';
import { ExperimentsRoot } from 'tachyon-experiments';
import { useRouterUtils } from 'tachyon-next-routing-utils';
import {
  EXPERIMENT_OVERRIDES_QUERY_PARAM_KEY,
  EXPERIMENT_SLOTS,
} from '../../../../../config';

type StarshotExperimentsRootProps = Omit<
  ExperimentsRootProps,
  'experimentOverrides' | 'experimentSlots' | 'onEvent'
>;

// istanbul ignore next: trivial
export const StarshotExperimentsRoot: FC<StarshotExperimentsRootProps> = (
  props,
) => {
  const trackEvent = useCustomTracking<ExperimentBranchEvent>();
  const { currentQuery } = useRouterUtils();
  // cached once on start up
  const { current: experimentOverrides } = useRef(
    currentQuery[EXPERIMENT_OVERRIDES_QUERY_PARAM_KEY],
  );

  return (
    <ExperimentsRoot
      experimentOverrides={experimentOverrides}
      experimentSlots={EXPERIMENT_SLOTS}
      onEvent={trackEvent}
      {...props}
    />
  );
};

StarshotExperimentsRoot.displayName = 'StarshotExperimentsRoot';
