import { useEffect } from 'react';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { useUserIntent } from 'tachyon-user-intent';
import { KeyValue, legacyKeyboardEventHandler } from 'tachyon-utils';
import { useTachyonRouter } from '../../../../../../routing';

// istanbul ignore next: low value
export function usePlaystation4Intent(): void {
  const {
    common: { platform },
  } = useStaticEnvironment();
  const { back } = useTachyonRouter();
  const { subscribeToIntent, triggerIntent } = useUserIntent();

  useEffect(() => {
    if (platform === Platform.PS4) {
      return subscribeToIntent({ callback: back, intent: 'back' });
    }
  }, [back, platform, subscribeToIntent]);

  useEffect(() => {
    if (platform !== Platform.PS4) {
      return;
    }
    const playstationKeyListener = legacyKeyboardEventHandler((event) => {
      const key = event.key as KeyValue;
      switch (key) {
        case KeyValue.Escape:
          triggerIntent('back');
          break;
        default:
          return;
      }
    });

    document.addEventListener('keydown', playstationKeyListener);

    return () => {
      document.removeEventListener('keydown', playstationKeyListener);
    };
  });
}
