import { useEffect } from 'react';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import {
  GamepadButton,
  GamepadButtonEvent,
  useGamepadInput,
} from 'tachyon-gamepad-input';
import { useTachyonRouter } from '../../../../../../routing';
import { useBrowserSoundEffects } from '../../../../../framework';

// istanbul ignore next: low value
export const useSwitchIntent = (): void => {
  const { subscribeToGamepadButtonInputEvent } = useGamepadInput();
  const { back } = useTachyonRouter();
  const {
    common: { platform },
  } = useStaticEnvironment();
  const { back: playBackSfx } = useBrowserSoundEffects();

  useEffect(() => {
    if (platform !== Platform.Switch) {
      return;
    }

    const gamepadButtonDownHandler = () => {
      back();
      playBackSfx?.();
    };

    return subscribeToGamepadButtonInputEvent({
      button: GamepadButton.FaceButtonDown,
      callback: gamepadButtonDownHandler,
      eventType: GamepadButtonEvent.onDown,
    });
  }, [back, platform, playBackSfx, subscribeToGamepadButtonInputEvent]);
};
