import { useEffect } from 'react';
import { useStaticEnvironment } from 'tachyon-environment';
import { useUserIntent } from 'tachyon-user-intent';
import { WHEEL_ENABLED_PLATFORMS } from '../../../../../../config';

// istanbul ignore next: low value
export const useWheelIntent = (): void => {
  const { triggerIntent } = useUserIntent();
  const {
    common: { platform },
  } = useStaticEnvironment();
  useEffect(() => {
    if (!WHEEL_ENABLED_PLATFORMS.includes(platform)) {
      return;
    }

    const wheelHandler = ({ deltaY }: WheelEvent) => {
      if (deltaY > 0) {
        triggerIntent('page-down');
      } else {
        triggerIntent('page-up');
      }
    };

    document.addEventListener('wheel', wheelHandler);

    return () => {
      document.removeEventListener('wheel', wheelHandler);
    };
  }, [platform, triggerIntent]);
};
