import { useCustomTracking } from 'tachyon-event-tracker';
import { initEnvironment } from 'tachyon-relay';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { StarshotQueryRendererRoot } from '.';

let mockIsBrowser = false;
jest.mock('tachyon-utils', () => ({
  ...jest.requireActual('tachyon-utils'),
  isBrowser: () => mockIsBrowser,
}));

const mockGetAuthToken = () => '';
const mockLogout = () => undefined;
jest.mock('tachyon-auth', () => ({
  useCurrentUser: jest.fn(() => ({
    getAuthToken: mockGetAuthToken,
    logout: mockLogout,
  })),
}));

jest.mock('tachyon-relay', () => ({
  ...jest.requireActual('tachyon-relay'),
  initEnvironment: jest.fn(),
}));
const mockInitEnvironment = initEnvironment as jest.Mock;

jest.mock('tachyon-event-tracker', () => ({
  ...jest.requireActual('tachyon-event-tracker'),
  useCustomTracking: jest.fn(),
}));
const mockUseCustomTracking = useCustomTracking as jest.Mock;

describe(StarshotQueryRendererRoot, () => {
  const setup = createShallowWrapperFactory(StarshotQueryRendererRoot, () => ({
    fetchPolicy: 'store-and-network',
    fetchQueryOpts: {},
    query: null,
    records: { records: true } as any,
    render: () => null,
    variables: {},
  }));

  beforeEach(() => {
    mockInitEnvironment.mockReset();
    mockUseCustomTracking.mockReset();
  });

  it('sets authorization in relay environment when in browser', () => {
    mockIsBrowser = true;
    const mockTrackEvent = jest.fn();
    mockUseCustomTracking.mockReturnValueOnce(mockTrackEvent);

    const { props } = setup();

    expect(mockInitEnvironment).toHaveBeenCalledWith({
      fetchQueryOpts: {
        ...props.fetchQueryOpts,
        authorization: {
          token: mockGetAuthToken,
          unauthorizedHandler: mockLogout,
        },
        onEvent: mockTrackEvent,
      },
      records: props.records,
    });
  });

  it('passes relay fetchQueryOpts and records unchanged when serverside', () => {
    mockIsBrowser = false;
    const { props } = setup();

    expect(mockInitEnvironment).toHaveBeenCalledWith({
      fetchQueryOpts: props.fetchQueryOpts,
      records: props.records,
    });
  });
});
