import type { FC } from 'react';

// istanbul ignore next: trivial
export const SwitchHead: FC = () => (
  <>
    <script
      // No XSS risk here because the content is static
      dangerouslySetInnerHTML={{
        // tells Switch web applet to hide the footer UI chrome
        // remove IntersectionObserver from window; per Nintendo, it is broken
        // unset B button, since we want to implement our own back behavior
        __html: `if(window.nx){
          window.nx.footer.setFixed("hidden");
          delete window.IntersectionObserver;
          window.nx.footer.unsetAssign("B");
        }`,
      }}
      type="text/javascript"
    />
    <meta
      // disables Switch's UA focus styles
      content="hidden"
      name="focus-ring-visibility"
    />
  </>
);

SwitchHead.displayName = 'SwitchHead';
