import type { ErrorInitialProps } from 'tachyon-page-utils';
import {
  defaultPageviewTracking,
  errorGetInitialProps,
  getCurrentUser,
} from 'tachyon-page-utils';
import { InternalServerError } from '../../errors';
import type { StarshotPage } from '../types';

// istanbul ignore next: trivial
export const StarshotError: StarshotPage<ErrorInitialProps> = () => {
  return <InternalServerError />;
};

StarshotError.currentUser = getCurrentUser;
StarshotError.displayName = 'StarshotError';
StarshotError.navigationBehavior = () => ({
  displayNavMenu: true,
});
StarshotError.pageviewTracking = defaultPageviewTracking;

// istanbul ignore next: trivial
StarshotError.getInitialProps = (ctx) =>
  errorGetInitialProps({ package: 'starshot' }, ctx);
