import { graphql } from 'react-relay/hooks';
import type {
  TachyonGetServerSideProps,
  TachyonPage,
  TachyonPageContext,
} from 'tachyon-next-types';
import type {
  StarshotPageContextExtensions,
  StarshotPageExtensions,
  StarshotRequestExtensions,
} from '../../config';
import type { TopNavDisplayOptions } from '../common';

// TODO: use conditional typing to enforce that if Query is present
// props must include currentUser for better enforcement of desired logic

export type PageNavigationBehavior = TopNavDisplayOptions & {
  /**
   * Tells the navigation system that the page has no content that can
   * be navigated to.
   */
  noFocusableContent?: true;
  /**
   * Controls whether the top nav has a background.
   */
  topNavBackground?: true;
};

export type StarshotPageContext = TachyonPageContext<
  {},
  StarshotRequestExtensions,
  StarshotPageContextExtensions
>;

export type StarshotPage<
  InitialProps = {},
  Props extends InitialProps = InitialProps,
  Query = {},
  ReqExt = {},
> = TachyonPage<
  InitialProps,
  Props,
  Query,
  ReqExt,
  StarshotPageContextExtensions,
  StarshotPageExtensions
>;

export type StarshotGetServerSideProps<
  ServerSideProps = {},
  Query = {},
  ReqExt = {},
> = TachyonGetServerSideProps<ServerSideProps, Query, ReqExt>;

/*
 * We may want to consider moving these into a context with CurrentUserRoot or
 * something similar
 */
// eslint-disable-next-line no-unused-expressions
graphql`
  fragment types_currentUser on User {
    id
    login
    roles {
      isStaff
    }
  }
`;
