import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { SVGAsset } from 'twitch-core-ui';
import { FocusableIconButton } from '../../common';

export type ClosedCaptionsButtonProps = {
  captionsEnabled: boolean;
  focusIndex: number;
  onClick: () => void;
};

export const ClosedCaptionsButton: FC<ClosedCaptionsButtonProps> = ({
  captionsEnabled,
  focusIndex,
  onClick,
}) => {
  const { formatMessage } = useIntl();

  const label = captionsEnabled
    ? formatMessage('Turn off captions', 'ClosedCaptionsButton')
    : formatMessage('Turn on captions', 'ClosedCaptionsButton');

  return (
    <FocusableIconButton
      aria-label={label}
      focusIndex={focusIndex}
      icon={captionsEnabled ? SVGAsset.CC : SVGAsset.CCOff}
      onClick={onClick}
    />
  );
};

ClosedCaptionsButton.displayName = 'ClosedCaptionsButton';
