import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVGAsset } from 'twitch-core-ui';
import { FocusableIconButton } from '../../common';
import { ClosedCaptionsButton } from '.';

describe(ClosedCaptionsButton, () => {
  const setup = createShallowWrapperFactory(ClosedCaptionsButton, () => ({
    captionsEnabled: false,
    focusIndex: 0,
    onClick: jest.fn(),
  }));

  it('renders a disabled state', () => {
    const { wrapper } = setup({ captionsEnabled: false });
    expect(wrapper.find(FocusableIconButton).props()).toMatchObject({
      'aria-label': 'Turn on captions',
      icon: SVGAsset.CCOff,
    });
  });

  it('renders an enabled state', () => {
    const { wrapper } = setup({ captionsEnabled: true });
    expect(wrapper.find(FocusableIconButton).props()).toMatchObject({
      'aria-label': 'Turn off captions',
      icon: SVGAsset.CC,
    });
  });
});
