import type { FC, PropsWithChildren } from 'react';
import styled from 'styled-components';
import {
  Align,
  AlignItems,
  Aspect,
  AspectRatio,
  Background,
  Display,
  FlexDirection,
  FlexWrap,
  JustifyContent,
  Layout,
  Position,
} from 'twitch-core-ui';

// istanbul ignore next: trivial
const ScHorizontallyPaddedLayout = styled(Layout)`
  padding-left: 10rem;
  padding-right: 10rem;
`;

export type FullscreenOverlayPromptProps = {
  transparent?: true;
};

// istanbul ignore next: trivial

/**
 * A component designed to make it easier to build full screen video overlay prompts.
 * A typical overlay component might look something like:
 * <FullscreenOverlayPrompt>
 *   <FullscreenOverlayPrompt.Image>
 *     {your_image_here}
 *   <FullscreenOverlayPrompt.Image>
 *   <FullscreenOverlayPrompt.CTA>
 *     {custom_cta_ux_here}
 *   </FullscreenOverlayPrompt.CTA>
 * </FullscreenOverlayPrompt>
 */
export const FullscreenOverlayPrompt: FC<
  PropsWithChildren<FullscreenOverlayPromptProps>
> & {
  CTA: FC;
  Image: FC;
} = ({ children, transparent }) => (
  <Layout
    attachBottom
    attachLeft
    attachRight
    attachTop
    position={Position.Absolute}
  >
    <ScHorizontallyPaddedLayout
      alignItems={AlignItems.Center}
      background={transparent ? Background.Overlay : Background.Base}
      display={Display.Flex}
      fullHeight
      fullWidth
      justifyContent={JustifyContent.Around}
    >
      {children}
    </ScHorizontallyPaddedLayout>
  </Layout>
);
FullscreenOverlayPrompt.displayName = 'FullscreenOverlayPrompt';

// istanbul ignore next: trivial
const ScCtaContainer = styled(Layout)`
  max-width: 40rem;
  min-width: 30rem;
`;

// istanbul ignore next: trivial
FullscreenOverlayPrompt.CTA = ({ children }) => {
  return (
    <ScCtaContainer
      display={Display.Flex}
      flexDirection={FlexDirection.Column}
      flexWrap={FlexWrap.Wrap}
      fullHeight
      justifyContent={JustifyContent.Center}
    >
      {children}
    </ScCtaContainer>
  );
};
FullscreenOverlayPrompt.CTA.displayName = 'FullscreenOverlayPromptCTA';

// istanbul ignore next: trivial
const ScImageContainer = styled.div`
  width: 30rem;
`;

// istanbul ignore next: trivial
FullscreenOverlayPrompt.Image = ({ children }) => (
  <ScImageContainer>
    <Aspect align={Align.Center} ratio={AspectRatio.Aspect1x1}>
      {children}
    </Aspect>
  </ScImageContainer>
);
FullscreenOverlayPrompt.Image.displayName = 'FullscreenOverlayPromptImage';
