import { usePlaybackState } from 'pulsar';
import type { FC } from 'react';
import { useEffect, useState } from 'react';
import styled from 'styled-components';
import { useIntl } from 'tachyon-intl';
import { CoreButton, SVG, SVGAsset } from 'twitch-core-ui';
import { accessiblyHide } from '../../../common';
import { useScrubControls } from '../ScrubControls';

export const ScPausedIndicator = styled.div<{ $hide: boolean }>`
  display: flex;
  height: 100%;
  ${accessiblyHide};
`;

export const ScPlayPauseButton = styled(CoreButton)`
  height: 100%;
  width: 100%;
`;

export const HideablePlayPauseButton: FC = () => {
  const { subscribeToScrubbingPositionSeconds, togglePlay } =
    useScrubControls();
  const [isScrubbing, setIsScrubbing] = useState(false);
  const playbackState = usePlaybackState();
  const { formatMessage } = useIntl();
  const ariaLabel =
    playbackState === 'Playing'
      ? formatMessage('Pause', 'HideablePlayPauseButton')
      : formatMessage('Play', 'HideablePlayPauseButton');

  useEffect(() => {
    return subscribeToScrubbingPositionSeconds((scrubbingPositionSeconds) => {
      setIsScrubbing(scrubbingPositionSeconds !== undefined);
    });
  }, [subscribeToScrubbingPositionSeconds, setIsScrubbing]);
  return (
    // if playbackState is anything other than Idle or if we're scrubbing, hide the button
    <ScPausedIndicator $hide={isScrubbing || playbackState !== 'Idle'}>
      <ScPlayPauseButton
        aria-label={ariaLabel}
        onClick={togglePlay}
        role="button"
      >
        <SVG asset={SVGAsset.Play} height={120} width={120} />
      </ScPlayPauseButton>
    </ScPausedIndicator>
  );
};

HideablePlayPauseButton.displayName = 'HideablePlayPauseButton';
