import { usePlaybackState, usePlayerController } from 'pulsar';
import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { CoreButtonType, SVGAsset } from 'twitch-core-ui';
import { FocusableIconButton } from '../../../common';

type PlayPauseButtonProps = {
  focusIndex: number;
};

export const PlayPauseButton: FC<PlayPauseButtonProps> = ({ focusIndex }) => {
  const { formatMessage } = useIntl();
  const controller = usePlayerController();
  const playbackState = usePlaybackState();

  const props =
    playbackState === 'Playing'
      ? {
          'aria-label': formatMessage('Pause', 'PlayPauseButton'),
          icon: SVGAsset.MiniPlayerPause,
          onClick: () => {
            controller?.pause();
          },
        }
      : {
          'aria-label': formatMessage('Play', 'PlayPauseButton'),
          icon: SVGAsset.MiniPlayerPlay,
          onClick: () => {
            controller?.play();
          },
        };

  return (
    <FocusableIconButton
      focusIndex={focusIndex}
      focusedType={CoreButtonType.Text}
      withUnfocusBackground
      {...props}
    />
  );
};

PlayPauseButton.displayName = 'PlayPauseButton';
