import {
  mockPlayerController,
  usePlaybackState,
  usePlayerController,
} from 'pulsar';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { SVGAsset } from 'twitch-core-ui';
import { FocusableIconButton } from '../../../common';
import { PlayPauseButton } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlaybackState: jest.fn(),
  usePlayerController: jest.fn(),
}));

const mockUsePlayerController = usePlayerController as jest.Mock;
const mockUsePlaybackState = usePlaybackState as jest.Mock;

describe(PlayPauseButton, () => {
  const setup = createShallowWrapperFactory(PlayPauseButton, () => ({
    focusIndex: 0,
  }));

  beforeEach(() => {
    jest.resetAllMocks();

    mockUsePlayerController.mockReturnValue(
      mockPlayerController({ pause: jest.fn(), play: jest.fn() }),
    );
  });

  describe('when the player is in a playing state', () => {
    beforeEach(() => {
      mockUsePlaybackState.mockReturnValue('Playing');
    });

    it('renders the pause icon', () => {
      const { wrapper } = setup();

      expect(wrapper.find(FocusableIconButton)).toHaveProp({
        icon: SVGAsset.MiniPlayerPause,
      });
    });

    it('clicking the button calls pause', () => {
      const { wrapper } = setup();
      expect(mockUsePlayerController().pause).not.toHaveBeenCalled();

      wrapper.find(FocusableIconButton).simulate('click');
      expect(mockUsePlayerController().pause).toHaveBeenCalledTimes(1);
    });
  });

  describe('when the player is in a non-playing state', () => {
    beforeEach(() => {
      mockUsePlaybackState.mockReturnValue('Buffering');
    });

    it('renders the playing icon', () => {
      const { wrapper } = setup();

      expect(wrapper.find(FocusableIconButton)).toHaveProp({
        icon: SVGAsset.MiniPlayerPlay,
      });
    });

    it('clicking the button calls play', () => {
      const { wrapper } = setup();
      expect(mockUsePlayerController().play).not.toHaveBeenCalled();

      wrapper.find(FocusableIconButton).simulate('click');
      expect(mockUsePlayerController().play).toHaveBeenCalledTimes(1);
    });
  });
});
