import type { FC } from 'react';
import styled from 'styled-components';
import { refFocusHandler } from 'tachyon-tv-nav';
import { formatVideoLength } from 'tachyon-utils';
import { CoreText } from 'twitch-core-ui';
import { StaticTokenMap } from 'twitch-core-ui-tokens';
import { KEY_NAV_THROTTLE_WAIT_S } from '../../../../../config';
import type { FocusableStyleProps } from '../../../../common';
import { focusableBorderStyle } from '../../../../common';
import { PROGRESS_INDICATOR_HEIGHT_REM, TOTAL_HEIGHT_REM } from '../ui';

const ScPlayerHeadContainer = styled.div`
  display: flex;
  flex-direction: column;
  height: ${TOTAL_HEIGHT_REM}rem;
  pointer-events: none;
  position: absolute;
  transform: translateX(-50%);
`;

const ScProgressHead = styled.button<FocusableStyleProps>`
  background: ${StaticTokenMap['color-white']};
  border: solid 0.25rem ${StaticTokenMap['color-black']} !important;
  border-radius: 100% !important;
  height: ${PROGRESS_INDICATOR_HEIGHT_REM}rem;
  margin: 0 auto;
  ${focusableBorderStyle}
  width: ${PROGRESS_INDICATOR_HEIGHT_REM}rem;
`;

const ScVideoTimeText = styled(CoreText)`
  margin-top: auto;
`;

// istanbul ignore next: trivial
function getPlayerHeadStyles(isAccelerating: boolean | undefined) {
  return isAccelerating
    ? {
        transition: `transform ${KEY_NAV_THROTTLE_WAIT_S * 2}s linear`,
      }
    : {};
}

export type PlayerHeadProps = {
  focused: boolean;
  isAccelerating?: boolean;
  playerHeadOffset: number;
  playerHeadSeconds: number;
};

/* eslint-disable react/forbid-dom-props */
// istanbul ignore next: trivial
export const PlayerHead: FC<PlayerHeadProps> = ({
  focused,
  isAccelerating,
  playerHeadOffset,
  playerHeadSeconds,
}) => (
  <div
    style={{
      transform: `translateX(${playerHeadOffset}%)`,
      ...getPlayerHeadStyles(isAccelerating),
    }}
  >
    <ScPlayerHeadContainer>
      <ScProgressHead $focused={focused} ref={refFocusHandler(focused)} />

      <ScVideoTimeText>{formatVideoLength(playerHeadSeconds)}</ScVideoTimeText>
    </ScPlayerHeadContainer>
  </div>
);

PlayerHead.displayName = 'PlayerHead';
