import type { FC } from 'react';
import type { CSSObject } from 'styled-components';
import styled from 'styled-components';
import { DarkThemeMap, StaticTokenMap } from 'twitch-core-ui-tokens';
import { PROGRESS_BAR_HEIGHT_REM, PROGRESS_INDICATOR_HEIGHT_REM } from '../ui';

// Seek bar needs to be vertically positioned so that the progress head
// is centered
const PROGRESS_BAR_TOP_POS_REM =
  PROGRESS_INDICATOR_HEIGHT_REM / 2 - PROGRESS_BAR_HEIGHT_REM / 2;

// istanbul ignore next: trivial
function seekBarStyle(): CSSObject {
  return {
    height: `${PROGRESS_BAR_HEIGHT_REM}rem`,
    left: 0,
    position: 'absolute',
    top: `${PROGRESS_BAR_TOP_POS_REM}rem`,
    width: '100%',
  };
}

const ScCurrentProgressBar = styled.div`
  background: ${DarkThemeMap['color-background-progress-status']};
  ${seekBarStyle}
  transform-origin: left;
`;

const ScBackgroundBar = styled.div`
  background: ${StaticTokenMap['color-opac-w-2']};
  ${seekBarStyle}
`;

export type ProgressBarProps = {
  currentPositionPercent: number;
};

// istanbul ignore next: trivial
export const ProgressBar: FC<ProgressBarProps> = ({
  currentPositionPercent,
}) => {
  return (
    <>
      <ScBackgroundBar />
      {/*
        This component uses currentPositionPercent intentionally to give the user
        orientation during scrubbing. We use inline styles to keep from generating
        tons of styled components.
      */}
      <ScCurrentProgressBar
        style={{
          transform: `scale3d(${currentPositionPercent}, 1, 1)`,
        }}
      />
    </>
  );
};

ProgressBar.displayName = 'ProgressBar';
