import { getPercentagePositions } from './utils';

describe('getPercentagePositions', () => {
  it.each`
    totalVideoTimeSeconds | currentPlaybackPositionSeconds | playHeadPositionSeconds | currentPositionPercent | playHeadPositionPercent
    ${undefined}          | ${20}                          | ${25}                   | ${0}                   | ${0}
    ${100}                | ${25}                          | ${50}                   | ${0.25}                | ${50}
  `(
    `currentPositionPercent is $currentPositionPercent and playHeadPositionPercent is $playHeadPositionPercent when totalVideoTimeSeconds is $totalVideoTimeSeconds, currentPlaybackPositionSeconds is $currentPlaybackPositionSeconds, and playHeadPositionSeconds is $playHeadPositionSeconds`,
    ({
      currentPlaybackPositionSeconds,
      currentPositionPercent,
      playHeadPositionPercent,
      playHeadPositionSeconds,
      totalVideoTimeSeconds,
    }) => {
      expect(
        getPercentagePositions(
          totalVideoTimeSeconds,
          currentPlaybackPositionSeconds,
          playHeadPositionSeconds,
        ),
      ).toEqual({ currentPositionPercent, playHeadPositionPercent });
    },
  );
});
