export function getPercentagePositions(
  totalVideoTimeSeconds: number | undefined,
  currentPlaybackPositionSeconds: number,
  playHeadPositionSeconds: number,
): { currentPositionPercent: number; playHeadPositionPercent: number } {
  return totalVideoTimeSeconds
    ? {
        currentPositionPercent:
          currentPlaybackPositionSeconds / totalVideoTimeSeconds,
        playHeadPositionPercent:
          (playHeadPositionSeconds / totalVideoTimeSeconds) * 100,
      }
    : { currentPositionPercent: 0, playHeadPositionPercent: 0 };
}
