export type AccelerationGears = Array<number>;

// istanbul ignore next: low value
export function quadratic(minSpeed: number, range: number): AccelerationGears {
  const numberOfGears = 10;
  const maxSpeedCoefficient = 0.05;
  /**
   * We use a quadratic equation to build accelerationGears from
   * our minSpeed to maxSpeed (determined as a fraction of range)
   * to create a gradual acceleration.
   */
  const maxSpeed = range * maxSpeedCoefficient;
  const coefficient = (maxSpeed - minSpeed) / Math.pow(numberOfGears - 1, 2);

  return Array.from({
    length: numberOfGears,
  }).map((_, index) => Math.floor(coefficient * Math.pow(index, 2) + minSpeed));
}
