import { act, renderHook } from '@testing-library/react-hooks';
import type { UseScrubAccelerationProps } from '.';
import { clampSpeedOnUpperBound, useScrubAcceleration } from '.';

describe(useScrubAcceleration, () => {
  const initialProps: UseScrubAccelerationProps = {
    minSpeed: 10,
    range: 1000,
    upperBound: 1000,
  };

  it('sets isAccelerating and resets based on imperitive actions', () => {
    const { result } = renderHook((props) => useScrubAcceleration(props), {
      initialProps,
    });

    expect(result.current.isAccelerating()).toBeFalsy();

    act(() => {
      result.current.accelerate(0);
    });

    expect(result.current.isAccelerating()).toBeTruthy();

    act(() => {
      result.current.resetAcceleration();
    });

    expect(result.current.isAccelerating()).toBeFalsy();
  });
});

describe(clampSpeedOnUpperBound, () => {
  it.each`
    currentValue | increment | upperBound | expected
    ${0}         | ${10}     | ${1000}    | ${10}
    ${20}        | ${10}     | ${25}      | ${25}
    ${30}        | ${10}     | ${0}       | ${20}
    ${0}         | ${10}     | ${0}       | ${0}
  `(
    'returns $expected when currentValue is $currentValue increment is $increment and upperBound is $upperBound',
    ({ currentValue, expected, increment, upperBound }) => {
      expect(clampSpeedOnUpperBound(currentValue, increment, upperBound)).toBe(
        expected,
      );
    },
  );
});
