import { usePlaybackState } from 'pulsar';
import type { FC } from 'react';
import { LoadingContent } from '../../common';

/**
 * Component used to display a loading spinner while we wait
 * for the player to be instantiated and initialized.
 */
export const PlayerLoadingOverlay: FC = ({ children }) => {
  const playerState = usePlaybackState();
  return (
    <>
      {children}
      {(playerState === 'Initializing' || playerState === 'Buffering') && (
        <LoadingContent />
      )}
    </>
  );
};
PlayerLoadingOverlay.displayName = 'PlayerLoadingOverlay';
