import { usePlaybackState } from 'pulsar';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { LoadingContent } from '../../common';
import { PlayerLoadingOverlay } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlaybackState: jest.fn(),
}));

const mockUsePlaybackState = usePlaybackState as jest.Mock;

const MockChildren = () => <div />;

describe(PlayerLoadingOverlay, () => {
  const setup = createShallowWrapperFactory(PlayerLoadingOverlay, () => ({
    children: <MockChildren />,
    status: 'initialized',
  }));

  it('it shows a loading spinner when player is buffering', () => {
    mockUsePlaybackState.mockReturnValue('Buffering');
    const { wrapper } = setup();
    expect(wrapper.find(MockChildren)).toExist();
    expect(wrapper.find(LoadingContent)).toExist();
  });

  it('it shows a loading spinner when player is initializing', () => {
    mockUsePlaybackState.mockReturnValue('Initializing');
    const { wrapper } = setup();
    expect(wrapper.find(MockChildren)).toExist();
    expect(wrapper.find(LoadingContent)).toExist();
  });

  it('does not render loading content when playing', () => {
    mockUsePlaybackState.mockReturnValue('Playing');
    const { wrapper } = setup();
    expect(wrapper.find(MockChildren)).toExist();
    expect(wrapper.find(LoadingContent)).not.toExist();
  });
});
