import { usePlayerController } from 'pulsar';
import { useEffect, useRef } from 'react';
import { useMountedState, usePrevious } from 'tachyon-utils';
import { useAppVisibility } from '../../../../common';

/**
 * To sanity check:
 * Start video playback, turn volume up, change tabs, and hear that video has paused.
 */
export function useBackgroundVideoPauser(): void {
  const controller = usePlayerController();
  const visible = useAppVisibility();
  const isMounted = useMountedState();
  const prevVisible = usePrevious(visible);

  // Only resume the player if it was implicitly paused by backgrounding
  // the app. If it was paused before backgrounding, it should remain paused
  // upon restoring to the foreground.
  const wasPaused = useRef(false);

  useEffect(() => {
    if (!controller) {
      return;
    }

    // moved to background
    if (!visible && prevVisible) {
      if (!controller.isPaused()) {
        wasPaused.current = true;
        controller.pause();
      }
      // moved to foreground
    } else if (visible && !prevVisible) {
      if (wasPaused.current) {
        controller.play();
      }
      wasPaused.current = false;
    }
  }, [visible, prevVisible, isMounted, controller]);
}
