import type { PlayerController } from 'pulsar';
import { mockPlayerController } from 'pulsar';
import type { FC } from 'react';
import { createMountWrapperFactory, visibility } from 'tachyon-test-utils';
import { AppVisibilityRoot } from '../../../../common';
import { useBackgroundVideoPauser } from '.';

let mockedPlayerController: PlayerController;

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlayerController: () => mockedPlayerController,
}));

const MockConsumer: FC = () => {
  useBackgroundVideoPauser();
  return null;
};

describe(useBackgroundVideoPauser, () => {
  const { background, foreground } = visibility(document);

  let isPaused = false;

  const setup = createMountWrapperFactory(AppVisibilityRoot, () => ({
    children: <MockConsumer />,
  }));

  beforeEach(() => {
    isPaused = false;

    mockedPlayerController = mockPlayerController({
      isPaused: jest.fn(() => isPaused),
      pause: jest.fn(),
      play: jest.fn(),
    });
  });

  it('pauses when backgrounded', () => {
    foreground();
    setup();
    expect(mockedPlayerController.pause).not.toHaveBeenCalled();
    expect(mockedPlayerController.play).not.toHaveBeenCalled();

    background();
    expect(mockedPlayerController.pause).toHaveBeenCalledTimes(1);
    expect(mockedPlayerController.play).not.toHaveBeenCalled();
  });

  it('plays when moving from background to foreground', () => {
    background();
    setup();
    expect(mockedPlayerController.pause).not.toHaveBeenCalled();
    expect(mockedPlayerController.play).not.toHaveBeenCalled();

    foreground();
    expect(mockedPlayerController.play).toHaveBeenCalledTimes(1);
    expect(mockedPlayerController.pause).not.toHaveBeenCalled();
  });

  it('does not play when the player was paused before backgrounding', () => {
    isPaused = true;
    foreground();
    setup();
    background();
    foreground();

    expect(mockedPlayerController.pause).not.toHaveBeenCalled();
    expect(mockedPlayerController.play).not.toHaveBeenCalled();
  });
});
