import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowWatchAgainSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { Display, Layout, Title } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type EndOfStreamPromptProps = {
  channel: { displayName: string; login: string };
  focusIndex: number;
};

// istanbul ignore next: trivial
export const EndOfStreamPrompt: FC<EndOfStreamPromptProps> = ({
  channel: { displayName, login },
  focusIndex,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FullscreenOverlayPrompt transparent>
      <FullscreenOverlayPrompt.Image>
        <GlowWatchAgainSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>
          {formatMessage('This stream has ended.', 'EndOfStreamPrompt')}
        </Title>
        <Layout display={Display.Flex} padding={{ top: 3 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton
              focusIndex={0}
              linkTo="/deferToRenderLink"
              renderLink={renderTachyonLink({
                route: RouteName.ChannelHome,
                routeParams: { login },
              })}
              withUnfocusBackground
            >
              {formatMessage(
                "Go to {displayName}'s profile",
                { displayName },
                'EndOfStreamPrompt',
              )}
            </FocusableTextButton>
            <Layout padding={{ x: 0.5 }} />
            <FocusableTextButton
              focusIndex={1}
              linkTo="/deferToRenderLink"
              renderLink={renderTachyonLink({
                route: RouteName.Homepage,
              })}
              withUnfocusBackground
            >
              {formatMessage('Go to home', 'EndOfStreamPrompt')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

EndOfStreamPrompt.displayName = 'EndOfStreamPrompt';
