import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowGeoBlockedSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreText, Display, Layout, Title } from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type GeoBlockedProps = {
  focusIndex: number;
};

// istanbul ignore next: trivial
export const GeoBlocked: FC<GeoBlockedProps> = ({ focusIndex }) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowGeoBlockedSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Oh bummer…', 'GeoBlocked')}</Title>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <CoreText>
            {formatMessage(
              'This premium content is not available in your region.',
              'GeoBlocked',
            )}
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton
              focusIndex={0}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'GeoBlocked')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

GeoBlocked.displayName = 'GeoBlocked';
