import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowMatureGateSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreText, Display, Layout, Title } from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type MatureGateProps = {
  focusIndex: number;
  onAccept: () => void;
};

// istanbul ignore next: trivial
export const MatureGate: FC<MatureGateProps> = ({ focusIndex, onAccept }) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowMatureGateSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Just one second…', 'MatureGate')}</Title>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <CoreText>
            {formatMessage(
              'The broadcaster has indicated that this channel is intended for mature audiences.',
              'MatureGate',
            )}
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton focusIndex={0} onClick={onAccept}>
              {formatMessage('Start Watching', 'MatureGate')}
            </FocusableTextButton>
            <Layout margin={{ left: 1 }} />
            <FocusableTextButton
              focusIndex={1}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'MatureGate')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

MatureGate.displayName = 'MatureGate';
