import type { Restriction } from 'pulsar';
import type { FC } from 'react';
import {
  GlowConcernedMonitor,
  GlowGeoBlockedSvg,
  GlowMatureGateSvg,
  GlowSubOnlySvg,
} from 'tachyon-more-ui';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { PreviewErrorOverlay } from '.';

describe(PreviewErrorOverlay, () => {
  const setup = createShallowWrapperFactory(PreviewErrorOverlay, () => ({
    restriction: 'gql-mature',
  }));

  const restrictionComponentMappings: {
    [key in Restriction]: FC<any>;
  } = {
    'gql-mature': GlowMatureGateSvg,
    'gql-sub-only': GlowSubOnlySvg,
    'gql-vod-muted-segments': GlowConcernedMonitor,
    'playback-ended': GlowConcernedMonitor,
    'playback-error': GlowConcernedMonitor,
    'player-auth-drm': GlowConcernedMonitor,
    'player-auth-geo': GlowGeoBlockedSvg,
    'player-auth-unknown': GlowConcernedMonitor,
    'player-auth-vod-sub-only': GlowSubOnlySvg,
  };

  it.each(Object.entries(restrictionComponentMappings))(
    'renders the right overlay for %s',
    (restriction, svg) => {
      const { wrapper } = setup({ restriction: restriction as Restriction });
      expect(wrapper.find(svg)).toExist();
    },
  );
});
