import type { FC } from 'react';
import { graphql } from 'react-relay/hooks';
import { useIntl } from 'tachyon-intl';
import { GlowSubOnlySvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import type { OmitRefType } from 'tachyon-type-library';
import {
  CoreText,
  Display,
  FlexDirection,
  Layout,
  Title,
} from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';
import type { SubOnlyLive_channel } from './__generated__/SubOnlyLive_channel.graphql';

// eslint-disable-next-line no-unused-expressions
graphql`
  fragment SubOnlyLive_channel on User {
    displayName
  }
`;

export type SubOnlyLiveProps = {
  channel: OmitRefType<SubOnlyLive_channel>;
  focusIndex: number;
};

// istanbul ignore next: trivial
export const SubOnlyLive: FC<SubOnlyLiveProps> = ({
  channel: { displayName },
  focusIndex,
}) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowSubOnlySvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Subscribers Only', 'SubOnly')}</Title>
        <Layout
          display={Display.Flex}
          flexDirection={FlexDirection.Column}
          padding={{ top: 2 }}
        >
          <CoreText>
            {formatMessage(
              '{displayName} is streaming for subscribers. Subscribe from your browser to watch and support {displayName}.',
              { displayName },
              'SubOnlyLive',
            )}
            <Layout padding={{ top: 2 }}>
              {formatMessage(
                'Get Ad free viewing on this channel (with limited exception), ability to watch and chat during sub-only streams, Subscriber emotes, and a Subscriber badge.',
                'SubOnlyLive',
              )}
            </Layout>
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton
              focusIndex={0}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'SubOnly')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

SubOnlyLive.displayName = 'SubOnlyLive';
