import type { FC } from 'react';
import { graphql } from 'react-relay/hooks';
import { useIntl } from 'tachyon-intl';
import { GlowSubOnlySvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import type { OmitRefType } from 'tachyon-type-library';
import {
  CoreText,
  Display,
  FlexDirection,
  Layout,
  Title,
} from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';
import type { SubOnlyVideo_video } from './__generated__/SubOnlyVideo_video.graphql';

// eslint-disable-next-line no-unused-expressions
graphql`
  fragment SubOnlyVideo_video on Video {
    owner {
      displayName
    }
  }
`;

export type SubOnlyVideoProps = {
  focusIndex: number;
  video: OmitRefType<SubOnlyVideo_video>;
};

// istanbul ignore next: trivial
export const SubOnlyVideo: FC<SubOnlyVideoProps> = ({ focusIndex, video }) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowSubOnlySvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Subscribers Only', 'SubOnlyVideo')}</Title>
        <Layout
          display={Display.Flex}
          flexDirection={FlexDirection.Column}
          padding={{ top: 2 }}
        >
          <CoreText>
            {video.owner
              ? formatMessage(
                  'This video is only available to subscribers. Subscribe from your browser to watch and support {displayName}.',
                  { displayName: video.owner.displayName },
                  'SubOnlyVideo',
                )
              : formatMessage(
                  'This video is only available to subscribers. Subscribe from your browser to watch and support this channel.',
                  'SubOnlyVideo',
                )}
            <Layout padding={{ top: 2 }}>
              {formatMessage(
                'Get Ad free viewing on this channel (with limited exception), ability to watch and chat during sub-only streams, Subscriber emotes, and a Subscriber badge.',
                'SubOnlyVideo',
              )}
            </Layout>
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton
              focusIndex={0}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'SubOnlyVideo')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

SubOnlyVideo.displayName = 'SubOnlyVideo';
