import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowErrorCarSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreText, Display, Layout, Title } from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type UnknownRestrictionProps = {
  focusIndex: number;
};

// istanbul ignore next: trivial
export const UnknownRestriction: FC<UnknownRestrictionProps> = ({
  focusIndex,
}) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowErrorCarSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Oh bummer…', 'UnknownRestriction')}</Title>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <CoreText>
            {formatMessage(
              'This content is not available.',
              'UnknownRestriction',
            )}
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton
              focusIndex={0}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'UnknownRestriction')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

UnknownRestriction.displayName = 'UnknownRestriction';
