import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowErrorCarSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { CoreText, Display, Layout, Title } from 'twitch-core-ui';
import { useTachyonRouter } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type VideoErrorProps = {
  focusIndex: number;
  onReloadClick: () => void;
};

// istanbul ignore next: trivial
export const VideoError: FC<VideoErrorProps> = ({
  focusIndex,
  onReloadClick,
}) => {
  const { formatMessage } = useIntl();
  const { back } = useTachyonRouter();

  return (
    <FullscreenOverlayPrompt>
      <FullscreenOverlayPrompt.Image>
        <GlowErrorCarSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Oh bummer…', 'VideoError')}</Title>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <CoreText>
            {formatMessage(
              'An error occurred while playing this content',
              'VideoError',
            )}
          </CoreText>
        </Layout>
        <Layout display={Display.Flex} padding={{ top: 2 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            <FocusableTextButton focusIndex={0} onClick={onReloadClick}>
              {formatMessage('Reload', 'VideoError')}
            </FocusableTextButton>
            <Layout margin={{ left: 1 }} />
            <FocusableTextButton
              focusIndex={1}
              onClick={back}
              withUnfocusBackground
            >
              {formatMessage('Go Back', 'VideoError')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

VideoError.displayName = 'VideoError';
