import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { mockRouter } from '../../../../../routing/test-mocks';
import { FocusableTextButton } from '../../../../common';
import { VideoError } from '.';

jest.mock('../../../../../routing', () => ({
  useTachyonRouter: () => mockRouter,
}));

describe(VideoError, () => {
  const setup = createShallowWrapperFactory(VideoError, () => ({
    focusIndex: 0,
    onReloadClick: jest.fn(),
  }));

  it('invokes onReloadClick on first button click', () => {
    const { props, wrapper } = setup();
    wrapper.find(FocusableTextButton).first().simulate('click');
    expect(props.onReloadClick).toHaveBeenCalledTimes(1);
  });

  it('invokes back on second button click', () => {
    const { wrapper } = setup();
    wrapper.find(FocusableTextButton).last().simulate('click');
    expect(mockRouter.back).toHaveBeenCalledTimes(1);
  });
});
