import { usePlaybackRestrictions, usePlayerError } from 'pulsar';
import type { FC } from 'react';
import { useEffect } from 'react';
import { PreviewErrorOverlay } from '../Overlays';
import type { BaseRestrictionProps } from '../types';

export type PreviewRestrictionProps = Omit<BaseRestrictionProps, 'focusIndex'>;

export const PreviewRestriction: FC<PreviewRestrictionProps> = ({
  children,
  passThrough = false,
}) => {
  const playerError = usePlayerError();
  const { activeRestriction, handlePlayerError } = usePlaybackRestrictions();
  useEffect(() => {
    if (playerError) {
      handlePlayerError(playerError);
    }
  }, [handlePlayerError, playerError]);

  if (
    passThrough ||
    activeRestriction === null ||
    // the preview player is muted so we can defer this
    // specific restriction until full screen playback
    activeRestriction === 'gql-vod-muted-segments'
  ) {
    return <>{children}</>;
  }
  return <PreviewErrorOverlay restriction={activeRestriction} />;
};

PreviewRestriction.displayName = 'PreviewRestriction';
