import { mockPlaybackRestrictions, usePlaybackRestrictions } from 'pulsar';
import { createShallowWrapperFactory } from 'tachyon-test-utils';
import { PreviewErrorOverlay } from '../Overlays';
import { PreviewRestriction } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlaybackRestrictions: jest.fn(() => null),
}));

const mockUsePlaybackRestrictions = usePlaybackRestrictions as jest.Mock;

describe(PreviewRestriction, () => {
  const setup = createShallowWrapperFactory(PreviewRestriction);

  describe('passThrough', () => {
    it('does not render the restriction when passThrough is true', () => {
      mockUsePlaybackRestrictions.mockReturnValue(
        mockPlaybackRestrictions({ activeRestriction: 'gql-mature' }),
      );
      const { wrapper } = setup({
        passThrough: true,
      });

      expect(wrapper.find(PreviewErrorOverlay)).not.toExist();
    });

    it('renders muted segments when the restriction is muted segments', () => {
      mockUsePlaybackRestrictions.mockReturnValue(
        mockPlaybackRestrictions({
          activeRestriction: 'gql-vod-muted-segments',
        }),
      );
      const { wrapper } = setup();

      expect(wrapper.find(PreviewErrorOverlay)).not.toExist();
    });

    it('renders muted segments when passThrough is true', () => {
      mockUsePlaybackRestrictions.mockReturnValue(
        mockPlaybackRestrictions({ activeRestriction: 'gql-mature' }),
      );
      const { wrapper } = setup();

      expect(wrapper.find(PreviewErrorOverlay)).toExist();
    });
  });
});
