import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import { GlowWatchAgainSvg } from 'tachyon-more-ui';
import { HorizontalNav } from 'tachyon-tv-nav';
import { Display, Layout, Title } from 'twitch-core-ui';
import { RouteName, renderTachyonLink } from '../../../../../routing';
import { FocusableTextButton } from '../../../../common';
import { FullscreenOverlayPrompt } from '../../../FullscreenOverlayPrompt';

export type EndOfVodPromptProps = {
  broadcasterLogin?: string;
  focusIndex: number;
  onWatchAgain: () => void;
};

// istanbul ignore next: trivial
export const EndOfVodPrompt: FC<EndOfVodPromptProps> = ({
  broadcasterLogin,
  focusIndex,
  onWatchAgain,
}) => {
  const { formatMessage } = useIntl();

  return (
    <FullscreenOverlayPrompt transparent>
      <FullscreenOverlayPrompt.Image>
        <GlowWatchAgainSvg />
      </FullscreenOverlayPrompt.Image>
      <FullscreenOverlayPrompt.CTA>
        <Title>{formatMessage('Watch Again?', 'EndOfVodPrompt')}</Title>
        <Layout display={Display.Flex} padding={{ top: 3 }}>
          <HorizontalNav elementCount={2} focusIndex={focusIndex}>
            {broadcasterLogin ? (
              <FocusableTextButton
                focusIndex={0}
                linkTo="/deferToRenderLink"
                renderLink={renderTachyonLink({
                  route: RouteName.ChannelHome,
                  routeParams: { login: broadcasterLogin },
                })}
                withUnfocusBackground
              >
                {formatMessage('No, go back to profile', 'EndOfVodPrompt')}
              </FocusableTextButton>
            ) : (
              <FocusableTextButton
                focusIndex={0}
                linkTo="/deferToRenderLink"
                renderLink={renderTachyonLink({
                  route: RouteName.Homepage,
                })}
                withUnfocusBackground
              >
                {formatMessage('No, go back to home', 'EndOfVodPrompt')}
              </FocusableTextButton>
            )}
            <Layout margin={{ left: 1 }} />
            <FocusableTextButton
              focusIndex={1}
              onClick={onWatchAgain}
              withUnfocusBackground
            >
              {formatMessage('Yes, watch it again', 'EndOfVodPrompt')}
            </FocusableTextButton>
          </HorizontalNav>
        </Layout>
      </FullscreenOverlayPrompt.CTA>
    </FullscreenOverlayPrompt>
  );
};

EndOfVodPrompt.displayName = 'EndOfVodPrompt';
