import type { FC } from 'react';
import { useIntl } from 'tachyon-intl';
import type { StreamType } from 'tachyon-more-ui';
import { StreamTypeIndicator, formatLiveViewersCount } from 'tachyon-more-ui';
import { Layout, MediaCardStat, Position } from 'twitch-core-ui';

type StreamPlayerOverlayProps = {
  streamType: StreamType;
  viewersCount: number;
};

// istanbul ignore next: trivial
/**
 * Component that renders additional stuff on top of a playing stream,
 * indicating information like stream type and viewer count.
 */
export const StreamPlayerOverlay: FC<StreamPlayerOverlayProps> = ({
  streamType,
  viewersCount,
}) => {
  const { formatMessage, formatNumberShort } = useIntl();
  return (
    <>
      <Layout
        attachLeft
        attachTop
        margin={{ left: 1, top: 1 }}
        position={Position.Absolute}
      >
        <StreamTypeIndicator
          isOverlay={false}
          isPulsing={false}
          streamType={streamType}
        />
      </Layout>
      <Layout
        attachBottom
        attachLeft
        margin={{ bottom: 1, left: 1 }}
        position={Position.Absolute}
      >
        <MediaCardStat>
          {formatLiveViewersCount(
            formatMessage,
            viewersCount,
            formatNumberShort(viewersCount, {
              maximumSignificantDigits: 2,
            }),
          )}
        </MediaCardStat>
      </Layout>
    </>
  );
};
StreamPlayerOverlay.displayName = 'StreamPlayerOverlay';
