import { date, image, internet } from 'faker';
import { usePlayerError } from 'pulsar';
import { Platform, useStaticEnvironment } from 'tachyon-environment';
import { validId } from 'tachyon-relay';
import { createShallowWrapperFactory, randomId } from 'tachyon-test-utils';
import { CoreImage } from 'twitch-core-ui';
import { VodPreviewPlayerWrapper } from '../VodPlayer';
import { VodPlayerOverlay } from './VodPlayerOverlay';
import { VodPreviewPlayerBase } from '.';

jest.mock('pulsar', () => ({
  ...jest.requireActual('pulsar'),
  usePlayerError: jest.fn(),
}));
jest.mock('tachyon-environment', () => ({
  ...jest.requireActual('tachyon-environment'),
  useStaticEnvironment: jest.fn(),
}));

const mockUsePlayerError = usePlayerError as jest.Mock;
const mockUseStaticEnvironment = useStaticEnvironment as jest.Mock;

describe(VodPreviewPlayerBase, () => {
  const setup = createShallowWrapperFactory(VodPreviewPlayerBase, () => ({
    currentUser: null,
    video: {
      ' $fragmentRefs': {
        VodPlayerBase_video: true,
        VodPlayerOverlay_video: true,
        VodRestriction_video: true,
      },
      ' $refType': 'VodPreviewPlayer_video',
      createdAt: date.past(),
      id: validId(randomId()),
      lengthSeconds: 0,
      muteInfo: { mutedSegmentConnection: { nodes: [] } },
      owner: {
        broadcastSettings: {
          isMature: false,
        },
        displayName: internet.userName(),
        id: validId(randomId()),
        login: internet.userName(),
        subscriptionProducts: null,
      },
      previewThumbnailURL: image.imageUrl(),
      resourceRestriction: {
        type: 'UNKNOWN',
      },
      self: null,
      viewCount: 0,
    },
    vodPreviewToken: {
      ' $fragmentRefs': { VodPreviewPlayerWrapper_previewToken: true },
    },
  }));

  beforeEach(() => {
    mockUsePlayerError.mockReset();
    mockUsePlayerError.mockReturnValue(null);
    mockUseStaticEnvironment.mockReturnValue({
      common: { platform: Platform.StarshotDev },
    });
  });

  it('displays the player overlay if there is a playing video', () => {
    const { wrapper } = setup();

    expect(wrapper.find(VodPreviewPlayerWrapper)).toExist();
    expect(wrapper.find(VodPlayerOverlay)).toExist();
  });

  it('displays a preview image on Switch', () => {
    mockUseStaticEnvironment.mockReturnValueOnce({
      common: { platform: Platform.Switch },
    });
    const { wrapper } = setup();

    expect(wrapper.find(VodPreviewPlayerWrapper)).not.toExist();
    expect(wrapper.find(VodPlayerOverlay)).not.toExist();
    expect(wrapper.find(CoreImage)).toExist();
  });
});
