import type { AnalyticsEvent } from 'pulsar';
import { useCallback, useMemo } from 'react';
import { useDiscoveryTracking } from 'tachyon-discovery';
import { useCustomTracking } from 'tachyon-event-tracker';

// istanbul ignore next: trivial
export function useDiscoveryTrackingEvent(): (e: AnalyticsEvent) => void {
  const trackEvent = useCustomTracking();
  const { getAndResetPlayerTracking } = useDiscoveryTracking();

  // getAndResetPlayerTracking isn't idempotent and subsequent re-renders will
  // cause the discovery tracking params to be empty
  const discoveryTrackingParams = useMemo(getAndResetPlayerTracking, [
    getAndResetPlayerTracking,
  ]);

  return useCallback(
    ({ name, properties }: AnalyticsEvent) => {
      trackEvent({
        event: name,
        ...properties,
        ...discoveryTrackingParams,
      });
    },
    [discoveryTrackingParams, trackEvent],
  );
}
